import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { outlineDecorator } from '../../../../stories';

import { MacAddressList } from './MacAddressList';

storiesOf('host|information/MacAddressList', module)
   .addDecorator(outlineDecorator)
   .add('One address', () => <MacAddressList item={'00:25:90:83:4e:53'} />)
   .add('Two addresses', () => <MacAddressList list={['00:25:90:83:1b:c2', '00:25:90:83:1b:c3']} />)
   .add('No addresses at all', () => <MacAddressList />)
   .add('Invalid address', () => <MacAddressList item={'not-valid-mac'} />);
