import { array, string } from 'prop-types';
import * as React from 'react';

import { MacAddress } from '../../../../models';

import { MacAddressItem } from './MacAddressItem';

interface IProps {
   item?: MacAddress;
   list?: MacAddress[];
}

export class MacAddressList extends React.PureComponent<IProps> {
   public static defaultProps = {
      list: [],
   };

   public static propTypes = {
      item: string,
      value: array,
   };

   public render() {
      const list = this.props.item ? [this.props.item] : this.props.list!;

      return list.map(ma => <MacAddressItem key={ma} value={ma} />);
   }
}
