import { MacAddress } from '../../../../models';

import { formatMacAddress } from './MacAddressPopup';

describe('MacAddressPopup', () => {
   describe('formatMacAddress', () => {
      const address: MacAddress = '00:25:90:83:4e:53';

      it('should return lowercased for canonical', () => {
         expect(formatMacAddress(address, 'canonical')).toBe('00:25:90:83:4e:53');
         expect(formatMacAddress(address.toUpperCase(), 'canonical')).toBe('00:25:90:83:4e:53');
      });

      it('should return short format', () => {
         expect(formatMacAddress(address, 'short')).toBe('0025.9083.4e53');
      });

      it('should return integer format', () => {
         // def mac_to_int(mac):
         //   return int(mac.replace(".", "").replace(":", ""), 16)
         expect(formatMacAddress(address, 'integer')).toBe('161338314323');
      });

      it('should support short format to format as integer', () => {
         expect(formatMacAddress('0025.9083.4e53', 'integer')).toBe('161338314323');
      });

      it('should return null if invalid', () => {
         expect(formatMacAddress('not-valid-mac', 'canonical')).toBeNull();
         expect(formatMacAddress('123123123123', 'canonical')).toBeNull();
      });
   });
});
