import { Collapse } from '@yandex-data-ui/common';
import * as React from 'react';
import { PropsWithChildren } from 'react';

import styles from './Section.module.css';

interface IProps {
   collapsed: boolean;
   title: string;
}

export const Section = React.memo(({ title, collapsed, children }: PropsWithChildren<IProps>) => (
   <Collapse className={styles.section} title={<h3 className={styles.title}>{title}</h3>} dafaultIsExpand={!collapsed}>
      <div className={styles.body}>{children}</div>
   </Collapse>
));

Section.displayName = 'Section';
