import { classNames } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import styles from './VlanTable.module.css';

interface IProps {
   list: number[];
   selected: number;
}

export const VlanTable = React.memo(({ list = [], selected }: IProps) => (
   <div className={styles.vlanTable}>
      {list.map(v => (
         <div key={v}>
            <span
               className={classNames(
                  {
                     [styles.selected]: v === selected,
                  },
                  styles.vlan,
               )}
               title={v === selected ? 'Native VLAN (untagged)' : ''}
            >
               {v}
            </span>
         </div>
      ))}
   </div>
));

VlanTable.displayName = 'VlanTable';
