import { Loader, PageError, WindowTitle } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useContext, useMemo } from 'react';
import { RouteComponentProps } from 'react-router';

import { ILogUrlParams, OperationLog } from '../../../rich_shared';
import { HostContext } from '../../../shared';

type Props = RouteComponentProps<ILogUrlParams>;

export const HostOperationLog = React.memo((props: Props) => {
   const value = useContext(HostContext);
   const fqdn = useMemo(() => (value.host ? `${value.host!.name || ''} ${value.host!.inv}` : ''), [value]);

   const forceFilters = useMemo(() => {
      const filters: any = {};

      if (fqdn) {
         filters.fqdn = fqdn;
      }

      return filters;
   }, [fqdn]);

   if (value.isLoading) {
      return <Loader text={'Host loading'} />;
   }

   if (!value.host) {
      return <PageError text={value.error} />;
   }

   /*
   if (id) {
      layout = 'single';
   }
*/

   return (
      <>
         <WindowTitle value={`Host ${value.host.name} operation log`} />
         <OperationLog layout={'host'} forceFilters={forceFilters} {...props} />
      </>
   );
});

HostOperationLog.displayName = 'HostOperationLog';
