import { Loader, PageError, WindowTitle } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

import { HostLogType } from '../../../models';
import { HostContext } from '../../../shared';

import { HostLogEnhanced } from '../components/HostLog';

export function HostProfilingLogConsumed() {
   return (
      <HostContext.Consumer>
         {value =>
            value.isLoading ? (
               <Loader text={'Host loading'} />
            ) : (
               <>
                  {value.host ? (
                     <>
                        <WindowTitle value={`Host ${value.host.name} profiling log`} />
                        <HostLogEnhanced hostUuid={value.host.uuid} type={HostLogType.Profile} />
                     </>
                  ) : (
                     <PageError text={value.error} />
                  )}
               </>
            )
         }
      </HostContext.Consumer>
   );
}
