import { AppRoute } from '@yandex-infracloud-ui/libs-next';

import { HostAuditLog } from './audit_log/HostAuditLog';
import { HostDeployLogConsumed } from './deploy_log/HostDeployLog';
import { HostHealthTabConsumed } from './health/HostHealthTab';
import { HostInformationConsumed } from './information/HostInformation';
import { HostProfilingLogConsumed } from './profiling_log/HostProfilingLog';
import { HostCoronerLogConsumed } from './coroner_log/HostCoronerLog';
import { HostRestrictionsConsumed } from './restrictions/HostRestrictions';
import { HostOperationLog } from './operation_log/HostOperationLog';

export const HOST_TABS: AppRoute[] = [
   { path: '/host/:id', exact: true, name: 'Information', component: HostInformationConsumed },
   { path: '/host/:id/restrictions', name: 'Restrictions', component: HostRestrictionsConsumed },
   { path: '/host/:id/health', name: 'Health', component: HostHealthTabConsumed },

   { path: '/host/:id/audit_log', name: 'Audit log', component: HostAuditLog },
   { path: '/host/:id/operation_log', name: 'Operation log', component: HostOperationLog },
   { path: '/host/:id/deploy_log', name: 'Deploy log', component: HostDeployLogConsumed },
   { path: '/host/:id/profiling_log', name: 'Profiling log', component: HostProfilingLogConsumed },
   { path: '/host/:id/coroner_log', name: 'Coroner log', component: HostCoronerLogConsumed },
];

export const SHADOW_HOST_TABS: AppRoute[] = [
   { path: '/host/:id', exact: true, name: 'Information', component: HostInformationConsumed },
   { path: '/host/:id/audit_log', name: 'Audit log', component: HostAuditLog },
];
