import { IResult, styleHelpers } from '@yandex-infracloud-ui/libs-next';
import { toasts } from '@yandex-infracloud-ui/libs';
import * as H from 'history';
import * as React from 'react';
import { useCallback } from 'react';
import { Link } from 'react-router-dom';

import { PlotAction, PlotActionButtons } from '../../../actions/maintenance_plot_actions';
import { EXTERNAL_LINKS, IMaintenancePlot, ROUTE_LINKS } from '../../../models';
import { useCanEditPlot } from '../../../shared';

import styles from './MaintenancePlotListItem.module.css';

interface IProps {
   item: IMaintenancePlot;
   location: H.Location;

   onRemoved(id: string): void;
}

export const MaintenancePlotListItem = React.memo(({ item, onRemoved, location }: IProps) => {
   const { id, meta_info } = item;
   const { name, abc_service_slug } = meta_info;

   // hooks
   const canEdit = useCanEditPlot(item);

   // handlers
   const remove = useCallback(
      (action: PlotAction, results: IResult[]) => {
         const result = results[0];
         if (!result.success) {
            toasts.apiError('Remove maintenance plot', result.response);

            return;
         }

         if (action === PlotAction.Remove) {
            onRemoved(id);
         }
      },
      [id, onRemoved],
   );

   // render
   return (
      <tr data-e2e={'MaintenancePlotListItem'} key={id}>
         <td>
            <Link to={{ pathname: ROUTE_LINKS.maintenancePlot(id), state: { prev: location } }}>{name}</Link>
         </td>
         <td className={styles.userList} style={{ padding: '.5rem 0' }}>
            <a
               href={EXTERNAL_LINKS.abc(abc_service_slug)}
               className={styleHelpers.externalLink}
               target={'_blank'}
               rel={'noopener noreferrer'}
            >
               {abc_service_slug}
            </a>
         </td>

         <td>{canEdit ? <PlotActionButtons cls={styles.buttons} context={item} onActionFinished={remove} /> : null}</td>
      </tr>
   );
});

MaintenancePlotListItem.displayName = 'MaintenancePlotListItem';
