import { classNames, ExtendedFieldConfig, Hint, SuggestLayer, useExtendedField } from '@yandex-infracloud-ui/libs-next';
import { IMaintenancePlot } from '../../../models/api_models/maintenance_plots';
import React from 'react';
import { OwnersField, SetListInput, TextInputField } from '../../../rich_shared/form_fields2';
import styles from './fields.module.css';

export const CommonSettings = (props: ExtendedFieldConfig<any, IMaintenancePlot, {}>) => {
   const { field } = useExtendedField(props);
   const { name } = field;

   return (
      <>
         <h2>Common Settings</h2>

         <h3>
            Common Scenario Settings
            <Hint text={'Common scenarios settings for all types of scenarios'} />
         </h3>

         <TextInputField
            {...props}
            className={classNames(props.className, styles.smallWidth)}
            label={'Global hosts limit'}
            name={`${name}.common_scenario_settings.dont_allow_start_scenario_if_total_number_of_active_hosts_more_than`}
            placeholder={'Number of hosts'}
            controlProps={{ type: 'number', range: { min: 40 } }}
            hint={"Don't allow start scenario if total number of active hosts more than entered number"}
         />
         <TextInputField
            {...props}
            className={classNames(props.className, styles.smallWidth)}
            label={'Auto-approve small scenarios'}
            name={`${name}.common_scenario_settings.total_number_of_active_hosts`}
            placeholder={'Number of hosts'}
            controlProps={{ type: 'number', range: { min: 0 } }}
            hint={
               "Don't create an approvement if the total count of taken hosts linked to the maintenance plot is less than given numbers"
            }
         />

         <h3>Maintenance Approvers</h3>

         <OwnersField
            {...props}
            className={classNames(props.className, styles.fullWidth)}
            label={'Logins'}
            name={`${name}.maintenance_approvers.logins`}
            placeholder={'Enter login'}
            controlProps={{ layer: SuggestLayer.People }}
         />
         <SetListInput
            {...props}
            className={classNames(props.className, styles.fullWidth)}
            label={'ABC Roles Codes'}
            name={`${name}.maintenance_approvers.abc_roles_codes`}
            placeholder={'Enter role codes'}
         />
         <SetListInput
            {...props}
            className={classNames(props.className, styles.fullWidth)}
            label={'ABC Role Scope Slug'}
            name={`${name}.maintenance_approvers.abc_role_scope_slugs`}
            placeholder={'Enter role scope slugs'}
         />
         <SetListInput
            {...props}
            className={classNames(props.className, styles.fullWidth)}
            label={'ABC Duty Schedule Slug'}
            name={`${name}.maintenance_approvers.abc_duty_schedule_slugs`}
            placeholder={'Enter duty schedule slug'}
         />
      </>
   );
};
