import { ExtendedFieldConfig, useExtendedField } from '@yandex-infracloud-ui/libs-next';
import { IMaintenancePlot } from '../../../models/api_models/maintenance_plots';
import React from 'react';
import { AbcServiceSlugField, TextInputField } from '../../../rich_shared/form_fields2';

export const MetaInfo = (props: ExtendedFieldConfig<any, IMaintenancePlot, {}>) => {
   const { field } = useExtendedField(props);
   const { name } = field;

   return (
      <>
         <h2>Meta Info</h2>

         <TextInputField
            {...props}
            label={'Plot Name'}
            name={`${name}.name`}
            placeholder={'Enter plot name'}
            required={true}
         />
         <TextInputField
            {...props}
            label={'Plot ID'}
            name={'id'}
            placeholder={'Enter plot ID'}
            required={true}
            hidden={(_, formikProps) => {
               return !formikProps.values._isNewPlot;
            }}
         />
         <AbcServiceSlugField
            {...props}
            label={'ABC Service Slug'}
            name={`${name}.abc_service_slug`}
            required={true}
            hint={'Case sensitivity field!'}
         />
      </>
   );
};
