import { CheckboxField2, isEmpty } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

import { IMaintenanceScenarioSetting } from '../../../models/api_models/maintenance_plots';

import { ScenarioType } from 'rich_shared/scenario_list/models';
import { TextInputField } from 'rich_shared/form_fields2';

import classes from './ScenarioSettings.module.css';

interface Props {
   value: IMaintenanceScenarioSetting;
   index: number;
   readonly: boolean;
   disabled: boolean;
   name: string;
   className?: string;

   isHidden?: boolean;
}

export const ScenarioSettingsItem: React.FC<Props> = props => {
   const { name, index, isHidden, value } = props;

   if (isHidden) return null;

   return (
      <div>
         <h3 className={classes.header}>Approvement Stage</h3>
         <TextInputField
            {...props}
            label={'Approval SLA'}
            name={`${name}[${index}].settings.approval_sla`}
            placeholder={'Number of seconds'}
            controlProps={{ type: 'number', range: { min: 0 }, units: 'seconds' }}
            hint={'SLA for approval of maintenance by the owners'}
         />

         <h3 className={classes.header}>Drain Stage</h3>
         <h4>CMS</h4>
         <CheckboxField2
            {...props}
            label={'Use YP SLA'}
            name={`${name}[${index}].settings.use_yp_sla`}
            hint={'Use special maintenance offset: two workdays in 4 day window before maintenance start time'}
            controlProps={{ disableIndeterminate: true }}
         >
            use
         </CheckboxField2>
         <TextInputField
            {...props}
            label={'Start requesting CMS beforehand'}
            name={`${name}[${index}].settings.request_cms_x_seconds_before_maintenance_start_time`}
            placeholder={'Number of seconds'}
            controlProps={{ type: 'number', range: { min: 0 }, units: 'seconds' }}
            hint={'Start requesting CMS to set maintenance on hosts X seconds before maintenance start time'}
            hidden={(_, formikProps) => formikProps.values.scenarios_settings?.[index]?.settings?.use_yp_sla}
         />

         <CheckboxField2
            {...props}
            label={'Ignore Cluster Management System'}
            name={`${name}[${index}].settings.ignore_cms_on_host_operations`}
            hint={"Don't request CMS to release host on any host operations (set-to-maintenance, reboot, etc)"}
            controlProps={{ disableIndeterminate: true }}
         >
            ignore
         </CheckboxField2>
         <h4>Power-off</h4>
         <TextInputField
            {...props}
            label={'Start poweroff beforehand'}
            name={`${name}[${index}].settings.start_power_off_x_seconds_before_maintenance_start_time`}
            placeholder={'Number of seconds'}
            controlProps={{ type: 'number', range: { min: 0 }, units: 'seconds' }}
            hint={'Start power off hosts X seconds before maintenance start time'}
            hidden={(_, formikProps) =>
               formikProps.values.scenarios_settings?.[index]?.scenario_type === ScenarioType.NOCHard
            }
            disabled={value.settings?.enable_manual_approval_after_hosts_power_off}
         />
         <CheckboxField2
            {...props}
            label={'Manual approval after hosts power off'}
            name={`${name}[${index}].settings.enable_manual_approval_after_hosts_power_off`}
            hint={'Enable manual approval after hosts power off'}
            controlProps={{ disableIndeterminate: true }}
            disabled={!isEmpty(value.settings?.start_power_off_x_seconds_before_maintenance_start_time)}
         >
            enable
         </CheckboxField2>
         <h4>Escalation</h4>
         <TextInputField
            {...props}
            label={'Call beforehand'}
            name={`${name}[${index}].settings.get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds`}
            placeholder={'Number of seconds'}
            controlProps={{ type: 'number', range: { min: 0 }, units: 'seconds' }}
            hint={'Get approvers to comment in startrek ticket in hosts not in maintenance by x seconds'}
         />
         <CheckboxField2
            {...props}
            label={'Call when maintenance starts'}
            name={`${name}[${index}].settings.get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time`}
            hint={'Get approvers to comment in startrek ticket if hosts not in maintenance by maintenance start time'}
            controlProps={{ disableIndeterminate: true }}
         >
            call
         </CheckboxField2>

         <h3 className={classes.header}>Return load Stage</h3>
         <CheckboxField2
            {...props}
            label={'Redeploy on MAC address change'}
            name={`${name}[${index}].settings.enable_redeploy_after_change_of_mac_address`}
            hint={'Enable redeploy if hosts mac addresses changed'}
            controlProps={{ disableIndeterminate: true }}
         >
            redeploy
         </CheckboxField2>
      </div>
   );
};

ScenarioSettingsItem.displayName = 'ScenarioSettingsItem';
