import { Json } from '@yandex-infracloud-ui/libs';
import { format } from 'date-fns';
import * as React from 'react';

import { EXTERNAL_LINKS } from '../../models';
import { config } from '../../services';
import { Page } from '../../shared';

import styles from './About.module.css';

export const About = () => (
   <Page title={'About'} header={<h1>About</h1>}>
      <table className={styles.table}>
         <tbody>
            <tr>
               <td>Build version</td>
               <td>
                  {config.version}{' '}
                  <a href={EXTERNAL_LINKS.uiChangelog()} target={'_blank'} rel={'noreferrer noopener'}>
                     Open changelog
                  </a>
               </td>
            </tr>
            <tr>
               <td>Build date</td>
               <td>{config.now ? format(config.now, 'yyyy-MM-dd HH:mm') : null}</td>
            </tr>
            <tr>
               <td>UI_CONFIG</td>
               <td>
                  <Json obj={config.rawConfig} />
               </td>
            </tr>
         </tbody>
      </table>
   </Page>
);

About.displayName = 'About';
