import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import error404Svg from '../../design/icons/404.svg';

import { ROUTE_LINKS } from '../../models';
import { ErrorScreen } from '../../shared';

export function Error404Screen(props: RouteComponentProps<any>) {
   return (
      <ErrorScreen
         title={'404 Not found'}
         useButton={true}
         buttonText={'Go to main page'}
         buttonUrl={ROUTE_LINKS.home()}
         imgSrc={error404Svg}
         imgAlt={'Error 404: Not found'}
      >
         Pathname <code>{props.location.pathname}</code> is not supported in the UI.
      </ErrorScreen>
   );
}
