import * as React from 'react';
import { Link } from 'react-router-dom';
import { Page } from '../../shared';

interface IRouteConfig {
   [key: string]: string;
}

interface IRouteGroups {
   [key: string]: IRouteConfig;
}

// noinspection SpellCheckingInspection
const links: IRouteGroups = {
   'Audit log': {
      '/log/?host=zfront-i24.kaizen.yandex.net': 'Host audit log',
      '/log/?issuer=khoden': 'Issuer filter',
      '/log/?status%5B0%5D=failed': 'Status filter',
      '/log/?type%5B0%5D=add-host': 'Type filter',
      '/log/test/': 'Project audit log',
      '/log/test/?start_time=1554066000&end_time=1554411600': 'Log with time filters',
   },
   'Automation plots': {
      '/automation-plots': 'Automation plots',
      '/automation-plots/rtc': 'Automation plot edit',
   },
   'Host list': {
      '/?config=zen-raid10-ubuntu-14.04': 'Deploy config filter',
      '/?hosts=100061004': 'Link to one host',
      '/?hosts=100061004,900181673': 'Link to two host',
      '/?hosts=iva*': 'Host list by pattern',
      '/?physical_location=RU%7CSAS': 'Location filter',
      '/?restrictions%5B0%5D=redeploy': 'Restriction filter',
      '/?status%5B0%5D=adding': 'Filter hosts by status',
      '/?status%5B0%5D=adding&status%5B1%5D=changing-disk': 'Filter hosts by multiple status',
      '/?status%5B0%5D=ready&status%5B1%5D=manual&health%5B0%5D=failure': 'Waiting hosts',
      '/?switch=iva3-s12': 'Switch filter',
   },
   'Project': {
      '/project/test/?hosts=iva': 'Hosts in project',
      '/project/test/info/': 'Project settings',
   },
};

export const OldRoutes = React.memo(() => {
   return (
      <Page title={'Old routes support'}>
         {Object.keys(links).map(groupName => (
            <section key={groupName}>
               <h3>{groupName}</h3>
               <ul>
                  {Object.keys(links[groupName]).map(url => (
                     <li key={url}>
                        <Link to={url}>{links[groupName][url]}</Link> <code>{url}</code>
                     </li>
                  ))}
               </ul>
            </section>
         ))}
      </Page>
   );
});

OldRoutes.displayName = 'OldRoutes';
