import { PageError, WindowTitle } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useContext } from 'react';
import { RouteComponentProps } from 'react-router';
import { PreorderContext } from 'shared/contexts';

import { AuditLog, ILogUrlParams } from '../../../../rich_shared';

export const PreorderAuditLog = React.memo((props: RouteComponentProps<ILogUrlParams>) => {
   // region hooks
   const context = useContext(PreorderContext);
   // endregion

   // region render
   return (
      <>
         {context.preorderId ? (
            <>
               <WindowTitle value={`Preorder #${context.preorderId} audit log`} />
               <AuditLog layout={'all'} forceFilters={{ preorder: new Set([context.preorderId]) }} {...props} />
            </>
         ) : (
            <PageError text={'Preorder audit log loading error'} />
         )}
      </>
   );
   // endregion
});
