import { IUserOrGroup, Loader, UserName, UserOrGroupType } from '@yandex-infracloud-ui/libs-next';
import * as H from 'history';
import * as React from 'react';
import { PropsWithChildren } from 'react';
import { Link } from 'react-router-dom';
import { IPreorder, ROUTE_LINKS } from '../../../../models';
import { ProjectName } from '../../../../shared';
import styles from './PreorderDetails.module.css';

interface IProps {
   preorder: IPreorder;
}

const Field = React.memo(({ title, children }: PropsWithChildren<{ title: string }>) => (
   <div className={styles.field}>
      <div className={styles.title}>{title}</div>
      <div className={styles.body}>{children}</div>
   </div>
));

export const PreorderDetails = React.memo(({ preorder }: IProps) => {
   if (!preorder.id) {
      return <Loader cls={styles.loader} />;
   }

   const owner: IUserOrGroup = { type: UserOrGroupType.People, id: preorder.owner };

   const projectLink: H.LocationDescriptorObject = {
      pathname: ROUTE_LINKS.project(preorder.project),
   };

   // render
   return (
      <div className={styles.details}>
         <Field title={'Project'}>
            <Link to={projectLink}>
               <ProjectName id={preorder.project} />
            </Link>
         </Field>

         <Field title={'Owner'}>
            <UserName avatar={true} value={owner} />
         </Field>
      </div>
   );
});
