import { PageError, styleHelpers, WindowTitle } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useContext } from 'react';
import { RouteComponentProps } from 'react-router';

import { PreorderContext } from '../../../../shared';

export const PreorderErrors = React.memo((props: RouteComponentProps) => {
   // region hooks
   const context = useContext(PreorderContext);
   // endregion

   // region render
   return (
      <>
         {context.preorderId ? (
            <>
               <WindowTitle value={`Preorder #${context.preorderId} errors`} />
               {context.errors.length === 0 ? <div className={styleHelpers.center}>No errors</div> : null}
               {context.errors.map(err => (
                  <div key={err.toString()}>{err}</div>
               ))}
            </>
         ) : (
            <PageError text={'Preorder errors loading error'} />
         )}
      </>
   );
   // endregion
});

PreorderErrors.displayName = 'PreorderErrors';
