import { PER_PAGE_DEFAULT } from '@yandex-infracloud-ui/libs-next';
import { IConstants, IHost } from '../../../../models';

export enum ActionType {
   BeforeLoading,
   Loaded,
   SetPage,
   SetPerPage,
   SetLoading,
   SetConstants,
}

interface IActionBeforeLoading {
   type: ActionType.BeforeLoading;
}

interface IActionSetLoading {
   isLoading: boolean;
   type: ActionType.SetLoading;
}

interface IActionLoaded {
   items: IHost[];
   type: ActionType.Loaded;
}

interface IActionSetPage {
   page: number;
   type: ActionType.SetPage;
}

interface IActionSetPerPage {
   perPage: number;
   type: ActionType.SetPerPage;
}

interface IActionSetConstants {
   constants: IConstants;
   type: ActionType.SetConstants;
}

type Action =
   | IActionBeforeLoading
   | IActionLoaded
   | IActionSetPage
   | IActionSetPerPage
   | IActionSetLoading
   | IActionSetConstants;

export const initialState = {
   constants: null as IConstants | null,
   isLoading: false,
   items: [] as IHost[],
   page: 1,
   perPage: PER_PAGE_DEFAULT,
};

type State = Readonly<typeof initialState>;

export const reducer = (state: State, action: Action): State => {
   switch (action.type) {
      case ActionType.BeforeLoading: {
         return {
            ...state,
            isLoading: true,
            items: [],
         };
      }

      case ActionType.Loaded: {
         return {
            ...state,
            isLoading: false,
            items: action.items,
         };
      }

      case ActionType.SetPage: {
         return {
            ...state,
            page: action.page,
         };
      }

      case ActionType.SetPerPage: {
         return {
            ...state,
            perPage: action.perPage,
         };
      }

      case ActionType.SetLoading: {
         return {
            ...state,
            isLoading: action.isLoading,
         };
      }

      case ActionType.SetConstants: {
         return {
            ...state,
            constants: action.constants,
         };
      }

      default:
         return state;
   }
};
