import { styleHelpers } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useContext } from 'react';
import { RouteComponentProps } from 'react-router';
import { HostListRich } from '../../../../rich_shared/host_list';
import { PreorderContext } from '../../../../shared';

export const PreorderHostList = React.memo((props: RouteComponentProps) => {
   const context = useContext(PreorderContext);
   const invs = new Set([...context.acquired_hosts, ...context.failed_hosts]);

   return (
      <>
         {invs.size === 0 ? (
            <div className={styleHelpers.center}>No data</div>
         ) : (
            <HostListRich {...props} forceIds={invs} />
         )}
      </>
   );
});

PreorderHostList.displayName = 'PreorderHostList';
