import { PageError, styleHelpers, WindowTitle } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useContext } from 'react';

import { RouteComponentProps } from 'react-router';
import { PreorderContext } from '../../../../shared';

export const PreorderMessages = React.memo((props: RouteComponentProps) => {
   // region hooks
   const context = useContext(PreorderContext);
   // endregion

   // region render
   return (
      <>
         {context.preorderId ? (
            <>
               <WindowTitle value={`Preorder #${context.preorderId} messages`} />
               {context.messages.length === 0 ? <div className={styleHelpers.center}>No messages</div> : null}
               {context.messages.map(err => (
                  <div key={err.toString()}>{err}</div>
               ))}
            </>
         ) : (
            <PageError text={'Preorder messages loading error'} />
         )}
      </>
   );
   // endregion
});

PreorderMessages.displayName = 'PreorderMessages';
