import { IPreorder } from '../../../models';

export enum ActionType {
   BeforeLoading,
   Loaded,
   SetLoading,
}

interface IActionBeforeLoading {
   type: ActionType.BeforeLoading;
}

interface IActionLoaded {
   preorder: IPreorder;
   type: ActionType.Loaded;
}

interface IActionSetLoading {
   isLoading: boolean;
   type: ActionType.SetLoading;
}

type Action = IActionLoaded | IActionSetLoading | IActionBeforeLoading;

export const initialState = {
   isLoading: true,
   preorder: {} as IPreorder,
};

export type State = Readonly<typeof initialState>;

export const reducer = (state: State, action: Action): State => {
   switch (action.type) {
      case ActionType.BeforeLoading: {
         return {
            ...state,
            isLoading: true,
         };
      }

      case ActionType.Loaded: {
         return {
            ...state,
            isLoading: false,
            preorder: action.preorder,
         };
      }

      case ActionType.SetLoading: {
         return {
            ...state,
            isLoading: action.isLoading,
         };
      }

      default: {
         return state;
      }
   }
};
