import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { Route, RouteComponentProps } from 'react-router';

import {
   fullWidthOutlineDecorator,
   modalsSupportDecorator,
   routerDecorator,
   toastsSupportDecorator,
} from '../../../stories';

import { PreorderList } from './list';

storiesOf('preorders|_list/PreorderList', module)
   .addDecorator(fullWidthOutlineDecorator)
   .addDecorator(routerDecorator)
   .addDecorator(toastsSupportDecorator)
   .addDecorator(modalsSupportDecorator)
   .add('regular', () => {
      const render = (props: RouteComponentProps<any>) => <PreorderList {...props} />;

      return <Route render={render} />;
   });
