import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as H from 'history';
import * as React from 'react';
import { IPreorder } from '../../../models';
import { routerDecorator, reduxStoryDecorator } from '../../../stories';
import { PreorderListItem } from './list_item';

// noinspection SpellCheckingInspection
const itemWithoutErrors: IPreorder = {
   acquired_hosts: [
      900925312,
      900926340,
      900919047,
      900399757,
      900926610,
      900926489,
      900926621,
      900927646,
      900928581,
      900919074,
      900926629,
      900926632,
      900919083,
      900926381,
      900926645,
      900926650,
      900926651,
      900926599,
      900927423,
      900928325,
      900927436,
      900928588,
      900926541,
      900926286,
      900926552,
      900927839,
      900926561,
      900927714,
      900926314,
      900927723,
      900926316,
      900926577,
      900927603,
      900914165,
      900914044,
      900926570,
      900926462,
   ],
   failed_hosts: [],
   id: 7707,
   issuer: 'affe@',
   owner: 'sereglond',
   prepare: false,
   processed: true,
   project: 'search-new-mtn',
};

const notProcessedItem: IPreorder = {
   ...itemWithoutErrors,
   processed: false,
};

// noinspection SpellCheckingInspection
const itemWithErrors: IPreorder = {
   acquired_hosts: [
      100412433,
      100410369,
      100410370,
      100410371,
      100413444,
      100410374,
      100410375,
      100410376,
      100410377,
      100410379,
      100412940,
      100410381,
      100410382,
      100410383,
      100410384,
      100410385,
      100410386,
      100410387,
      100414063,
      100414485,
      100414486,
      100413976,
      100413479,
      100412763,
      100413359,
      100413980,
      100413981,
      100413982,
      100410373,
      100413475,
      100413476,
      100412965,
      100413478,
      100412967,
      100309544,
      100412969,
      100413485,
      100413486,
      100412977,
      100413480,
      100411964,
      100414013,
      100414014,
      100412992,
      100412993,
      100412995,
      100413528,
      100411975,
      100411976,
      100413002,
      100413566,
      100412941,
      100410451,
      100413524,
      100410453,
      100410454,
      100413527,
      100412437,
      100410457,
      100410458,
      100412943,
      100413532,
      100414078,
      100412663,
      100412944,
      100413328,
      100412774,
      100412518,
      100413969,
      100414057,
      100414058,
      100414059,
      100414060,
      100412525,
      100414062,
      100413039,
      100413040,
      100414065,
      100414066,
      100413276,
      100413561,
      100413562,
      100413051,
      100413052,
      100413565,
      100413054,
      100413567,
      100413056,
      100413569,
      100413058,
      100414084,
      100412438,
      100413062,
      100411532,
      100413070,
      100412085,
      100412526,
      100414103,
      100414104,
      100412059,
      100412060,
      100413722,
      100412062,
      100413599,
      100413600,
      100412065,
      100413979,
      100410125,
      100412585,
      100412586,
      100412083,
      100412084,
      100309534,
      100412086,
      100410313,
      100412089,
      100412090,
      100410388,
      100412095,
      100412096,
      100412100,
      100410230,
      100413638,
      100412104,
      100412876,
      100414154,
      100412619,
      100412620,
      100412621,
      100412110,
      100412623,
      100412624,
      100412625,
      100412626,
      100412627,
      100412628,
      100411940,
      100412111,
      100413477,
      100413153,
      100413154,
      100413563,
      100412133,
      100412134,
      100412135,
      100412136,
      100414076,
      100412138,
      100412139,
      100412140,
      100412770,
      100412142,
      100414077,
      100412658,
      100412659,
      100412662,
      100413481,
      100412664,
      100412666,
      100413055,
      100410452,
      100414080,
      100412968,
      100413057,
      100413570,
      100410126,
      100413061,
      100413713,
      100413714,
      100413715,
      100413716,
      100411669,
      100411670,
      100412695,
      100412696,
      100412697,
      100412942,
      100412699,
      100412700,
      100412702,
      100412703,
      100412704,
      100412141,
      100412205,
      100412206,
      100412207,
      100412209,
      100412210,
      100411703,
      100411704,
      100412729,
      100412730,
      100411708,
      100411709,
      100411710,
      100412735,
      100412736,
      100412737,
      100413970,
      100412739,
      100412740,
      100412741,
      100412742,
      100412517,
      100413973,
      100410493,
      100414064,
      100413271,
      100413272,
      100413273,
      100413274,
      100412764,
      100413277,
      100411743,
      100411744,
      100413793,
      100413794,
      100411747,
      100411748,
      100412773,
      100411750,
      100412769,
      100413530,
      100409467,
      100410228,
      100410229,
      100413526,
      100410231,
      100410232,
      100410233,
      100410235,
      100410236,
      100413525,
      100412434,
      100414075,
      100413440,
      100413319,
      100413320,
      100413327,
      100412622,
      100309404,
      100413977,
      100412835,
      100412836,
      100309414,
      100413357,
      100413358,
      100414109,
      100413361,
      100413362,
      100413364,
      100414110,
      100413366,
      100410295,
      100412366,
      100410297,
      100410298,
      100410299,
      100410300,
      100410301,
      100410302,
      100410304,
      100413442,
      100410307,
      100410309,
      100410310,
      100410312,
      100412873,
      100410314,
      100412875,
      100412364,
      100412365,
      100412367,
      100412368,
      100309464,
      100411969,
      100412891,
      100412892,
      100412893,
      100412894,
      100413443,
      100411594,
      100412966,
      100309484,
      100410494,
      100413523,
      100411895,
      100411896,
      100411897,
      100411898,
      100411899,
      100411900,
      100413437,
      100412661,
      101124096,
      101208605,
      100413482,
      101067783,
      101198361,
      100413529,
      100411491,
      100411492,
      100411531,
      101195934,
      101195945,
      101195946,
      101195948,
      101195951,
      101195953,
      101195954,
      101195955,
      101195968,
      101195973,
      101122600,
      101195981,
      101195984,
      101198366,
      101210501,
      100411707,
      101210478,
      101210480,
      101210482,
      101210483,
      101210484,
      101210486,
      101210487,
      101210488,
      101210489,
      101210490,
      101210491,
      101210493,
      101210495,
      101210496,
      101210499,
      101210500,
      100410303,
      101210503,
      101210504,
      101210506,
      101210507,
      101210508,
      101210509,
      101210510,
      101210511,
      100309394,
      101210521,
      101210522,
      101210523,
      101210525,
      101210528,
      101210529,
      101208602,
      101210531,
      101210533,
      101210535,
      101210536,
      101210524,
      101210539,
      101210546,
      101210567,
      101210575,
      101078435,
      101210580,
      101122525,
      101122526,
      101122527,
      101198308,
      101067857,
      101122538,
      101198315,
      101067858,
      101198318,
      101122544,
      101198321,
      101122546,
      101122547,
      101198324,
      101122550,
      101198335,
      101198337,
      101198338,
      101198342,
      101208585,
      100309514,
      101208592,
      101198356,
      101198358,
      100413978,
      101198367,
      101208609,
      101208613,
      101208614,
      101208615,
      101208617,
      101208624,
      101208625,
      101208628,
      101208630,
      100411982,
      101208678,
      101208696,
      101208705,
      101208707,
      101208709,
      101208711,
      101223545,
      101102773,
      101198316,
      101223552,
      101198320,
      101122535,
      101198317,
      101067680,
      101067681,
      101067692,
      101067693,
      101067694,
      101067695,
      101067696,
      101067697,
      101198323,
      101067702,
      101067703,
      101067711,
      101198327,
      101198328,
      101198329,
      101198330,
      101067743,
      101067744,
      100410378,
      101225497,
      101225499,
      101225502,
      101225503,
      101198326,
      101225514,
      101225516,
      101067821,
      101067836,
      101067837,
      101067838,
      101067839,
      101067840,
      101067843,
      101067844,
      101067853,
      101067854,
      100410447,
      100410448,
      100410449,
      100410450,
      101067871,
      101067872,
      101225576,
      101223541,
      101223542,
      101223636,
      101208596,
      101223548,
      101198322,
      101223553,
      101223557,
      101223558,
      101198359,
      101122584,
      101122585,
      101223580,
      101198362,
      101208603,
      101223589,
      101102764,
      101102765,
      101198365,
      101102772,
      101102774,
      101223614,
      101223645,
      101198364,
      101223635,
      101078463,
      101078464,
      101078509,
      101222322,
      101124020,
      100413053,
      100413065,
      101074571,
      101074572,
      101074573,
      101074577,
      101122588,
      101074587,
      101074588,
      101074595,
      101074596,
      101208689,
      101074600,
      101074601,
      101074602,
      101074603,
      101074604,
      101074609,
      101074610,
      101074612,
      101074617,
      101074618,
      101074635,
      100413149,
      101208702,
      101203710,
      101208704,
      101208708,
      101203743,
      101203744,
      101222288,
      101203756,
      101203757,
      101198354,
      101222260,
      101222284,
      101222290,
      101222291,
      101222295,
      101222298,
      101222301,
      101222302,
      101124019,
      101124023,
      101124031,
      101197760,
      101208586,
      101197766,
      101197768,
      101124046,
      101124063,
      101124087,
      101124088,
      101124102,
      101210463,
      100411529,
      100411530,
      100411533,
      100411534,
      101195949,
      101195977,
      101210459,
      100411749,
      101210481,
      101210485,
      101210502,
      101210517,
      101210518,
      101210564,
      101122543,
      101198325,
      101198339,
      101208584,
      101198350,
      101122594,
      100412099,
      100412103,
      101225504,
      101067834,
      101208593,
      101223543,
      101198372,
      101225549,
      101124015,
      101067710,
      101074611,
      100412363,
      101074636,
      101225493,
      101122587,
      100309494,
      101197769,
      101124066,
      101124070,
      101124092,
      101124094,
      101228311,
   ],
   errors: [
      "Failed to acquire #100413445: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100413975: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100412970: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100413365: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100412996: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100413001: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100411493: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100309454: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100412061: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100412657: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100412665: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100413275: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100413278: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100410234: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100413932: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100412878: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #100413439: The host already exists in 'search-new-mtn' project.",
      "Failed to acquire #101210460: The host is already registered in Wall-E and has 'invalid' status.",
   ],
   failed_hosts: [
      100413445,
      100413975,
      100412970,
      100413365,
      100412996,
      100413001,
      100411493,
      100309454,
      100412061,
      100412657,
      100412665,
      100413275,
      100413278,
      100410234,
      100413932,
      100412878,
      100413439,
      101210460,
   ],
   id: 6305,
   issuer: 'affe@',
   owner: 'bahbka',
   prepare: false,
   processed: false,
   project: 'search-new',
};

const fakeLocation: H.Location = {} as any;

storiesOf('preorders|_list/PreorderListItem', module)
   .addDecorator(routerDecorator)
   .addDecorator(reduxStoryDecorator)
   .add('success', () => (
      <table style={{ width: '100%' }}>
         <tbody>
            <PreorderListItem item={itemWithoutErrors} onReset={action('reset')} location={fakeLocation} />
         </tbody>
      </table>
   ))
   .add('not processed', () => (
      <table style={{ width: '100%' }}>
         <tbody>
            <PreorderListItem item={notProcessedItem} onReset={action('reset')} location={fakeLocation} />
         </tbody>
      </table>
   ))
   .add('lots of error', () => (
      <table style={{ width: '100%' }}>
         <tbody>
            <PreorderListItem item={itemWithErrors} onReset={action('reset')} location={fakeLocation} />
         </tbody>
      </table>
   ));
