import { IUserOrGroup, UserName, UserOrGroupType } from '@yandex-infracloud-ui/libs-next';
import * as H from 'history';
import * as React from 'react';
import { SyntheticEvent, useCallback } from 'react';
import { Link } from 'react-router-dom';
import { IPreorder, ROUTE_LINKS } from '../../../models';
import { ProjectName } from '../../../shared';
import { PreorderProgressBar } from '../components/PreorderProgressBar';
import { PreorderResetButton } from '../components/PreorderResetButton';
import styles from './list_item.module.css';

interface IProps {
   item: IPreorder;
   location: H.Location<any>;
   onReset: (e: SyntheticEvent, id: number) => void;
}

export const PreorderListItem = React.memo(({ location, item, onReset }: IProps) => {
   const owner: IUserOrGroup = { type: UserOrGroupType.People, id: item.owner };

   // handlers
   const reset = useCallback(
      (e: SyntheticEvent) => {
         onReset(e, item.id);
      },
      [item.id, onReset],
   );

   // render
   return (
      <tr data-e2e={'PreorderListItem'} className={styles.preorderItem}>
         <td>
            <Link to={{ pathname: ROUTE_LINKS.preorder(item.id), state: { prev: location } }}>{item.id}</Link>
         </td>
         <td>
            <UserName avatar={true} value={owner} />
         </td>
         {/*<td className={styles.status}></td> TODO status*/}
         <td className={styles.project}>
            <span title={item.project}>
               <ProjectName id={item.project} />
            </span>
         </td>
         <td className={styles.bar}>
            <PreorderProgressBar success={item.acquired_hosts} failed={item.failed_hosts || []} />

            {item.processed ? null : <PreorderResetButton cls={styles.resetButton} onClick={reset} />}
         </td>
      </tr>
   );
});

PreorderListItem.displayName = 'PreorderListItem';
