import { useDismounted } from '@yandex-infracloud-ui/libs-next';
import { toasts } from '@yandex-infracloud-ui/libs';
import { modalService } from '@yandex-infracloud-ui/libs';
import { Button } from '@yandex-data-ui/common';
import * as React from 'react';
import { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';
import { preorderApi } from '../../../services';

import { AddPreorderModal } from './AddPreorderModal';

interface IProps {
   onAdd(preorderId: number): void;
}

export const AddPreorderButton = React.memo(({ onAdd }: IProps) => {
   // region hooks
   const dismounted = useDismounted();
   // endregion

   // region handlers
   const openModal = useCallback(() => {
      modalService
         .open(AddPreorderModal, {}, false)
         .pipe(takeUntil(dismounted))
         .subscribe(
            params => {
               preorderApi
                  .addPreorder(params)
                  .pipe(takeUntil(dismounted))
                  .subscribe(() => {
                     toasts.success(`Pre-order #${params.id}`);
                     onAdd(params.id!);
                  }, toasts.handleApiError('pre-order adding'));
            },
            () => null, // just close
         );
   }, [dismounted, onAdd]);
   // endregion

   // region render
   return (
      <Button view={'action'} size={'m'} onClick={openModal}>
         Add pre-order
      </Button>
   );
   // endregion
});

AddPreorderButton.displayName = 'AddPreorderButton';
