import * as React from 'react';
import { useCallback } from 'react';
import { useSelector } from 'react-redux';
import { RouteComponentProps } from 'react-router';

import { ROUTE_LINKS } from '../../../models';
import { ProjectSelect2 } from '../../../rich_shared/ProjectSelect2/components/ProjectSelect2';
import { ProjectsHeader } from '../../../rich_shared/ProjectSelect2/components/ProjectsHeader';
import { Page, Sidebar, SidebarDirection, SidebarToggleButton } from '../../../shared';
import { idSetToSet } from '../../../state/commonModels';
import { RootState } from '../../../state/store';

import { AddPreorderButton } from './AddPreorderButton';
import classes from './PreorderListWrapper.module.css';

export const PreorderListWrapper: React.FC<RouteComponentProps> = React.memo(
   ({ location, history, match, children }) => {
      const { sidebarCollapsed } = useSelector((s: RootState) => ({
         selectedProjects: idSetToSet(s.projects.selectedIds),
         sidebarCollapsed: s.projects.isCollapsed,
      }));

      const onAdd = useCallback(
         (preorderId: number) => {
            history.push(ROUTE_LINKS.preorder(preorderId));
         },
         [history],
      );

      const sidebarFooter = (
         <>
            <SidebarToggleButton direction={SidebarDirection.Collapse} />
            <AddPreorderButton onAdd={onAdd} />
         </>
      );

      const header = <ProjectsHeader className={classes.header} history={history} location={location} match={match} />;

      return (
         <Sidebar isCollapsed={sidebarCollapsed} footer={sidebarFooter} content={<ProjectSelect2 />}>
            <Page header={header}>{children}</Page>
         </Sidebar>
      );
   },
);

PreorderListWrapper.displayName = 'PreorderListWrapper';
