import { _toParts, IPart } from './PreorderProgressBar';

describe('PreorderProgressBar', () => {
   it('should render one part for empty', () => {
      expect(_toParts([], [])).toEqual([{ percent: 100, failed: false, offset: 0 }] as IPart[]);
   });

   it('should render one success without failed', () => {
      expect(_toParts([1, 2, 3], [])).toEqual([{ percent: 100, failed: false, offset: 0 }] as IPart[]);
   });

   it('should render one failed if all failed', () => {
      expect(_toParts([], [2, 3, 4])).toEqual([{ percent: 100, failed: true, offset: 0 }] as IPart[]);
   });

   it('should render with simple error', () => {
      expect(_toParts([1], [2])).toEqual([
         { percent: 50, failed: false, offset: 0 },
         { percent: 50, failed: true, offset: 50 },
      ] as IPart[]);
   });

   it('should render with simple error2', () => {
      expect(_toParts([1, 4], [2, 3])).toEqual([
         { percent: 25, failed: false, offset: 0 },
         { percent: 50, failed: true, offset: 25 },
         { percent: 25, failed: false, offset: 75 },
      ] as IPart[]);
   });
});
