import { classNames } from '@yandex-infracloud-ui/libs-next';
import { RedoIcon } from 'design/icons';
import * as React from 'react';
import { SyntheticEvent } from 'react';

import styles from './PreorderResetButton.module.css';

interface IProps {
   cls?: string;

   onClick(e: SyntheticEvent | null): void;
}

export const PreorderResetButton = React.memo(({ cls = '', onClick }: IProps) => {
   return (
      <div className={classNames(styles.resetButton, cls)} onClick={onClick}>
         <RedoIcon />
         <span className={styles.resetTitle}>Restart</span>
      </div>
   );
});

PreorderResetButton.displayName = 'PreorderResetButton';
