import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import { modalService } from '@yandex-infracloud-ui/libs';
import { Button } from '@yandex-data-ui/common';
import * as React from 'react';

import { modalsSupportDecorator, userSwitcherDecorator } from '../../../stories';

import { PreorderResetModal } from './PreorderResetModal';

function ModalStory() {
   const open = () => {
      modalService.open(PreorderResetModal, {}).subscribe(action('ok'), action('close'));
   };

   return (
      <Button view={'action'} size={'m'} onClick={open}>
         Open
      </Button>
   );
}

storiesOf('preorders|components/PreorderResetModal', module)
   .addDecorator(modalsSupportDecorator)
   .addDecorator(userSwitcherDecorator)
   .add('regular', () => <PreorderResetModal cancel={action('cancel')} ok={action('ok')} />)
   .add('open modal', () => <ModalStory />);
