import { DISMISS_REASON, FormFieldType, FormLayout, IFormField } from '@yandex-infracloud-ui/libs-next';
import { IModalProps, ModalLayout } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useCallback, useState } from 'react';

import { globalState, IPreorderBaseParams } from '../../../models';

const fields: IFormField<IPreorderBaseParams>[] = [
   {
      label: 'Reason',
      name: 'reason',
      placeholder: 'Reason (optional)',
      type: FormFieldType.Text,
   },
   {
      checkboxLabel: 'Use admin privileges to process the request',
      isHidden: () => (globalState.user.value ? !globalState.user.value.isAdmin : true),
      name: 'sudo',
      type: FormFieldType.Boolean,
   },
];

export const PreorderResetModal = React.memo(({ ok, cancel }: IModalProps<IPreorderBaseParams>) => {
   // hooks
   const [value, setValue] = useState<IPreorderBaseParams>({
      reason: '',
      sudo: false,
   });

   // handlers
   const onOk = useCallback(() => ok(value), [ok, value]);
   const onDismiss = useCallback(() => cancel(DISMISS_REASON), [cancel]);
   const updateParams = useCallback((_, v: IPreorderBaseParams) => setValue(v), []);

   // render
   return (
      <ModalLayout title={'Restart preorder'} okLabel={'Confirm'} onOk={onOk} onDismiss={onDismiss}>
         <FormLayout onChange={updateParams} value={value} fields={fields} />
      </ModalLayout>
   );
});

PreorderResetModal.displayName = 'PreorderResetModal';
