import { AppRoute } from '@yandex-infracloud-ui/libs-next';
import { PreorderAuditLog } from './_item/components/PreorderAuditLog';
import { PreorderErrors } from './_item/components/PreorderErrors';
import { PreorderHostList } from './_item/components/PreorderHostList';
import { PreorderMessages } from './_item/components/PreorderMessages';
import { PreorderItem } from './_item/item';
import { PreorderList } from './_list/list';

export const PREORDER_TABS: AppRoute[] = [
   { path: '/preorders/:id', exact: true, name: 'Hosts', component: PreorderHostList },
   { path: '/preorders/:id/audit_log', name: 'Audit log', component: PreorderAuditLog },
   { path: '/preorders/:id/messages', name: 'Messages', component: PreorderMessages },
   { path: '/preorders/:id/errors', name: 'Errors', component: PreorderErrors },
];

export const ROUTES: AppRoute[] = [
   { path: '/preorders', exact: true, component: PreorderList },
   { path: '/preorders/:id', component: PreorderItem },
   ...PREORDER_TABS,
];
