import { action } from '@storybook/addon-actions';
import * as React from 'react';

import { reduxStoryDecorator, userSwitcherDecorator } from '../../../stories';
import { IStoryDefaults } from '../../../stories/typings';

import { CloneProjectModal } from './CloneProjectModal';

export const Regular = () => <CloneProjectModal ok={action('ok')} cancel={action('cancel')} />;

export const WithProject = () => (
   <CloneProjectModal ok={action('ok')} cancel={action('cancel')} initialProjectId={'test'} />
);

export default {
   decorators: [userSwitcherDecorator, reduxStoryDecorator],
   title: 'project|CloneProjectModal',
} as IStoryDefaults;
