import { ExtendedFieldConfig, getFieldLabels } from '@yandex-infracloud-ui/libs';
import { TextField2, InputField2 } from '@yandex-infracloud-ui/libs-next';
import { config } from 'services';
import { object, string } from 'yup';
import { InputWithCounterField, MyProjectSelectField } from '../../../rich_shared/form_fields2';

export const initialValue = {
   id: '',
   name: '',
   projectId: null as string | null,
   reason: '',
   yc_iam_folder_id: undefined as string | undefined,
};

export type CloneProjectFormParams = typeof initialValue;

export const fields: ExtendedFieldConfig<CloneProjectFormParams>[] = [
   {
      as: MyProjectSelectField,
      label: 'Your project to clone',
      name: 'projectId',
      required: true,
   },
   {
      as: InputWithCounterField,
      hint: 'Human readable ID',
      label: 'Project name',
      name: 'name',
      placeholder: 'Enter project name',
      required: true,
   },
   {
      as: InputWithCounterField,
      hint: 'Tech ID',
      label: 'Project ID/slug',
      name: 'id',
      placeholder: 'Enter project ID/slug',
      required: true,
   },
   {
      as: InputField2,
      label: 'Folder ID',
      hidden: () => !config.isExternal,
      name: 'yc_iam_folder_id',
      placeholder: 'Enter a folder ID for YC iam',
   },
   {
      as: TextField2,
      hint: 'Will be logged',
      label: 'Comment',
      name: 'reason',
      placeholder: 'Enter a reason for project creation',
   },
];

const getLabel = getFieldLabels(fields);

export const validationSchema = object<CloneProjectFormParams>({
   id: string().label(getLabel('id')!).required(),
   name: string().label(getLabel('name')!).required(),
   projectId: string().label('Project').nullable().required(),
   reason: string().label(getLabel('reason')!),
   yc_iam_folder_id: string().label(getLabel('yc_iam_folder_id')!),
});
