import { DeclarativeFields, FormHooks, FormHooksContext } from '@yandex-infracloud-ui/libs';
import { Form, useFormikContext } from 'formik';
import React, { PropsWithChildren, useMemo, useState } from 'react';

import { DefaultProvisioner, IDeployConfig } from '../../../models';
import { DebugForm } from '../../../shared';
import { idFromName } from '../../../utils';

import classes from './InternalForm.module.css';
import { fields, NewProjectShortFormParams } from './models';

interface Props {
   onChange(): void;
}

export const InternalForm: React.FC<PropsWithChildren<Props>> = ({ children, onChange }) => {
   const form = useFormikContext<NewProjectShortFormParams>();
   const [isIdChangedManually, setIsIdChangedManually] = useState(false);

   const { setFieldValue } = form;

   const formHooks = useMemo(
      () =>
         ({
            onFieldChange(field, value) {
               onChange();

               switch (field) {
                  case 'name': {
                     if (!isIdChangedManually) {
                        setFieldValue('id', idFromName(value as string));
                     }
                     break;
                  }

                  case 'id': {
                     setIsIdChangedManually(true);
                     break;
                  }

                  case 'deployConfig': {
                     const v: IDeployConfig | null = value as any;
                     setFieldValue('provisioner', v ? v.provisioner : DefaultProvisioner);
                  }
               }
            },
         } as FormHooks<NewProjectShortFormParams>),
      [isIdChangedManually, onChange, setFieldValue],
   );

   return (
      <Form className={classes.form}>
         <FormHooksContext.Provider value={formHooks}>
            <DeclarativeFields configs={fields} />
         </FormHooksContext.Provider>

         <footer className={classes.footer}>{children}</footer>

         <DebugForm />
      </Form>
   );
};

InternalForm.displayName = 'InternalForm';
