import { action } from '@storybook/addon-actions';
import { modalService, toasts, useDismounted } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';
import {
   modalsSupportDecorator,
   reduxStoryDecorator,
   routerDecorator,
   toastsSupportDecorator,
   userSwitcherDecorator,
} from '../../stories';
import { IStoryDefaults } from '../../stories/typings';

import { DefaultNewProjectMode, NewProjectModalWrapper, NewProjectMode } from './NewProjectModalWrapper';

export const Regular = () => (
   <NewProjectModalWrapper mode={DefaultNewProjectMode} cancel={action('cancel')} ok={action('ok')} />
);

export const Modal = () => {
   const dismounted = useDismounted();

   const open = useCallback(() => {
      modalService
         .open(NewProjectModalWrapper, { mode: NewProjectMode.Create }, false)
         .pipe(takeUntil(dismounted))
         .subscribe(v => {
            toasts.success('Project was created');
            action('success')(v);
         }, action('error or dismiss'));
   }, [dismounted]);

   return (
      <Button theme={'action'} size={'s'} onClick={open}>
         Open modal
      </Button>
   );
};

export default {
   decorators: [
      modalsSupportDecorator,
      toastsSupportDecorator,
      routerDecorator,
      reduxStoryDecorator,
      userSwitcherDecorator,
   ],
   title: 'project|NewProjectModalWrapper',
} as IStoryDefaults;
