import { DISMISS_REASON, IModalProps } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback, useState } from 'react';
import { Link } from 'react-router-dom';

import { IProject, ROUTE_LINKS } from '../../models';
import { LegoButton } from '../../shared/lego';

import { CloneProjectModal } from './CloneProjectModal/CloneProjectModal';
import { NewProjectModal } from './NewProjectModal/NewProjectModal';
import classes from './NewProjectModalWrapper.module.css';

export enum NewProjectMode {
   Create = 'create',
   Clone = 'clone',
}

export const DefaultNewProjectMode = NewProjectMode.Create;

interface Props extends IModalProps<IProject> {
   mode: NewProjectMode;
}

export const NewProjectModalWrapper: React.FC<Props> = ({ ok, cancel, mode: initialMode }) => {
   const [mode, setMode] = useState(initialMode);

   const openClone = useCallback(() => setMode(NewProjectMode.Clone), []);
   const openCreate = useCallback(() => setMode(NewProjectMode.Create), []);
   const cancelModal = useCallback(() => cancel(DISMISS_REASON), [cancel]);

   switch (mode) {
      case NewProjectMode.Create: {
         return (
            <NewProjectModal cancel={cancel} ok={ok}>
               <Link to={ROUTE_LINKS.projectNew()} onClick={cancelModal} className={classes.linkToFull}>
                  Go to full form
               </Link>

               <LegoButton
                  theme={'link'}
                  cls={classes.switcher}
                  onClick={openClone}
                  controlAttrs={{ 'data-e2e': 'CloneProjectButton' }}
               >
                  Clone existing project
               </LegoButton>
            </NewProjectModal>
         );
      }

      case NewProjectMode.Clone: {
         return (
            <CloneProjectModal cancel={cancel} ok={ok}>
               <Button theme={'link'} size={'s'} cls={classes.switcher} onClick={openCreate}>
                  Create new project
               </Button>
            </CloneProjectModal>
         );
      }
   }
};

NewProjectModalWrapper.displayName = 'NewProjectModalWrapper';
