import React from 'react';
import { StaticContext } from 'react-router';
import { Route, RouteComponentProps } from 'react-router-dom';

import { reduxStoryDecorator, routerDecorator } from '../../stories';
import { IStoryDefaults } from '../../stories/typings';

import { ProjectPage } from './ProjectPage';

export const Regular = () => (
   <Route
      id={'project_page'}
      render={(props: RouteComponentProps<{ id: string }, StaticContext, any>) => <ProjectPage {...props} />}
   />
);

export default {
   decorators: [reduxStoryDecorator, routerDecorator],
   title: 'project|ProjectPage',
} as IStoryDefaults;
