import { action } from '@storybook/addon-actions';
import { modalService, toasts, useDismounted } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';

import {
   modalsSupportDecorator,
   toastsSupportDecorator,
   userSwitcherDecorator,
   reduxStoryDecorator,
} from '../../../stories';
import { IStoryDefaults } from '../../../stories/typings';

import { RemoveProjectModal } from './RemoveProjectModal';

export const Form = () => <RemoveProjectModal projectId={'test1'} ok={action('ok')} cancel={action('cancel')} />;

export const Modal = () => {
   const dismounted = useDismounted();

   const open = useCallback(() => {
      modalService
         .open(RemoveProjectModal, { projectId: 'test' }, false)
         .pipe(takeUntil(dismounted))
         .subscribe(v => {
            toasts.success('Project has been removed');
            action('success')(v);
         }, action('error or dismiss'));
   }, [dismounted]);

   return (
      <Button theme={'action'} size={'s'} onClick={open}>
         Open modal
      </Button>
   );
};

export default {
   decorators: [modalsSupportDecorator, toastsSupportDecorator, userSwitcherDecorator, reduxStoryDecorator],
   title: 'project|RemoveProjectModal',
} as IStoryDefaults;
