import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import React from 'react';

import { IStoryDefaults } from '../../../stories/typings';

import { ProjectButtons } from './ProjectButtons';

export const Regular = () => (
   <ProjectButtons
      isNew={boolean('isNew', false)}
      isSaving={boolean('isSaving', false)}
      readonly={boolean('readonly', true)}
      canEdit={boolean('canEdit', true)}
      onSave={action('onSave')}
      onCancel={action('onCancel')}
      onRemove={action('onRemove')}
      onClone={action('onClone')}
   />
);

export default {
   title: 'project|components/ProjectButtons',
} as IStoryDefaults;
