import { Loader } from '@yandex-infracloud-ui/libs';
import { CopyIcon, DeleteIcon } from 'design/icons';
import React from 'react';

import { LegoButton } from '../../../shared/lego';

import classes from './ProjectButtons.module.css';

interface Props {
   canEdit: boolean;
   className?: string;
   isNew: boolean | null;
   isSaving: boolean;
   readonly: boolean;

   onCancel(): void;

   onSave(): void;

   onRemove(): void;

   onClone(): void;
}

export const ProjectButtons: React.FC<Props> = React.memo(
   ({ className, isNew, isSaving, readonly, canEdit, onSave, onCancel, onClone, onRemove }) => {
      // loading
      if (isNew === null) {
         return null;
      }

      // View mode
      if (readonly) {
         if (!canEdit) {
            return null;
         }

         return (
            <div className={className}>
               <LegoButton
                  cls={classes.buttonWithIcon}
                  onClick={onClone}
                  title={'Clone this project'}
                  controlAttrs={{ 'data-e2e': 'CloneProjectButton' }}
               >
                  <CopyIcon />
               </LegoButton>

               <LegoButton
                  cls={classes.buttonWithIcon}
                  onClick={onRemove}
                  title={'Remove this project'}
                  controlAttrs={{ 'data-e2e': 'RemoveProjectButton' }}
               >
                  <DeleteIcon />
               </LegoButton>
            </div>
         );
      }

      // Editing mode

      return (
         <div className={className}>
            {isNew ? (
               <LegoButton
                  cls={classes.linkButton}
                  theme={'link'}
                  onClick={onClone}
                  text={'Clone existing project'}
                  controlAttrs={{ 'data-e2e': 'CloneProjectButton' }}
               />
            ) : null}

            <LegoButton
               view={'default'}
               tone={'default'}
               cls={classes.button}
               disabled={isSaving}
               onClick={onCancel}
               controlAttrs={{ 'data-e2e': 'CancelButton' }}
            >
               Cancel
            </LegoButton>

            <LegoButton
               theme={'action'}
               view={'default'}
               tone={'default'}
               cls={classes.button}
               disabled={isSaving}
               onClick={onSave}
               controlAttrs={{ 'data-e2e': 'SaveProjectButton' }}
            >
               {isSaving ? <Loader text={isNew ? 'Creating' : 'Saving'} inline={true} /> : isNew ? 'Create' : 'Save'}
            </LegoButton>
         </div>
      );
   },
);

ProjectButtons.displayName = 'ProjectButtons';
