import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import React, { FC } from 'react';

import { fullWidthOutlineDecorator, routerDecorator } from '../../../stories';
import { IStoryDefaults } from '../../../stories/typings';

import { ProjectHeader } from './ProjectHeader';

interface StoryProps {
   isNew: boolean | null;
   isSaving: boolean;
   id: string;
   name: string;
   readonly: boolean;
}

const Story: FC<StoryProps> = ({ isNew, isSaving, readonly, id, name }) => (
   <ProjectHeader
      isNew={isNew}
      isSaving={isSaving}
      readonly={readonly}
      projectId={id}
      projectName={name}
      canEdit={boolean('canEdit', true)}
      onEdit={action('onEdit')}
      onSave={action('onSave')}
      onCancel={action('onCancel')}
      onRemove={action('onRemove')}
      onClone={action('onClone')}
   />
);

export const Loading = () => <Story isNew={null} isSaving={false} readonly={true} id={''} name={''} />;

export const New = () => <Story isNew={true} isSaving={false} readonly={false} id={''} name={''} />;

export const ViewMode = () => (
   <Story isNew={false} isSaving={false} readonly={true} id={'animals-botanik'} name={'Animals Botanik'} />
);

export const EditMode = () => (
   <Story isNew={false} isSaving={false} readonly={false} id={'animals-botanik'} name={'Animals Botanik'} />
);

export const Saving = () => (
   <Story isNew={false} isSaving={true} readonly={false} id={'animals-botanik'} name={'Animals Botanik'} />
);

export default {
   decorators: [routerDecorator, fullWidthOutlineDecorator],
   title: 'project|components/ProjectHeader',
} as IStoryDefaults;
