import { Loader, styleHelpers } from '@yandex-infracloud-ui/libs';
import { PencilIcon } from 'design/icons';
import React from 'react';
import { Link } from 'react-router-dom';

import { ROUTE_LINKS, EXTERNAL_LINKS } from '../../../models';
import { LegoButton } from '../../../shared/lego';
import { ProjectButtons } from './ProjectButtons';

import classes from './ProjectHeader.module.css';

interface Props {
   canEdit: boolean;
   isNew: boolean | null;
   isSaving: boolean;
   projectId: string | null;
   projectName: string | null;
   readonly: boolean;

   onEdit(): void;

   onCancel(): void;

   onSave(): void;

   onClone(): void;

   onRemove(): void;
}

export const ProjectHeader: React.FC<Props> = React.memo(
   ({ isNew, isSaving, readonly, canEdit, projectId, projectName, onEdit, onCancel, onSave, onClone, onRemove }) => (
      <div className={classes.header}>
         <div className={classes.titleRow}>
            {isNew === null ? (
               <h1>
                  <Loader text={'Project is loading'} inline={true} />
               </h1>
            ) : isNew ? (
               <h1>New project</h1>
            ) : (
               <>
                  <h1>{projectName}</h1>

                  {readonly && canEdit ? (
                     <LegoButton
                        cls={classes.editButton}
                        onClick={onEdit}
                        title={'Edit project'}
                        controlAttrs={{ 'data-e2e': 'EditProjectButton' }}
                     >
                        <PencilIcon />
                     </LegoButton>
                  ) : null}
               </>
            )}

            <div className={classes.separator} />

            <ProjectButtons
               className={classes.actions}
               isNew={isNew}
               isSaving={isSaving}
               readonly={readonly}
               canEdit={canEdit}
               onCancel={onCancel}
               onSave={onSave}
               onClone={onClone}
               onRemove={onRemove}
            />
         </div>

         {isNew === false ? (
            <nav className={classes.linksRow}>
               <Link to={ROUTE_LINKS.home({ project: projectId })} title={'View host list for this project'}>
                  Hosts
               </Link>

               <Link to={ROUTE_LINKS.auditLog({ project: projectId })} title={'View audit log for this project'}>
                  Audit log
               </Link>

               <a
                  href={EXTERNAL_LINKS.yasm(projectId!)}
                  className={styleHelpers.externalLink}
                  target={'_blank'}
                  rel={'noopener noreferrer'}
               >
                  Metrics
               </a>
            </nav>
         ) : null}
      </div>
   ),
);

ProjectHeader.displayName = 'ProjectHeader';
