import { clearParams, IPureValueProps, IValidationResult } from '@yandex-infracloud-ui/libs';

import { IProject } from '../../models';
import { formParamsToCms, FullProjectFormState } from '../../state/fullProjectForm';
import { deployingFields } from './sub_forms/DeployingForm/DeployingForm';
import { profilingFields } from './sub_forms/ProfilingForm/ProfilingForm';

export interface FormProps<T> extends IPureValueProps<T> {
   validation: IValidationResult<T>;
}

export function formParamsToProject(form: FullProjectFormState): Partial<IProject> {
   // tslint:disable:object-literal-sort-keys
   return {
      // basic settings
      name: form.basic.params.name,
      id: form.basic.params.id,
      tags: form.basic.params.tags,
      bot_project_id: form.basic.params.bot_project_id,
      owners: form.basic.params.owners,
      _owners: form.basic.params._owners,
      yc_iam_folder_id: form.basic.params.yc_iam_folder_id,
      type: form.basic.params.type,

      // cauth
      cauth_flow_type: form.cauth.params.flow_type,
      cauth_insecure_ca_list_url: form.cauth.params.insecure_ca_list_url,
      cauth_key_sources: form.cauth.params.key_sources,
      cauth_krl_url: form.cauth.params.krl_url,
      cauth_secure_ca_list_url: form.cauth.params.secure_ca_list_url,
      cauth_sudo_ca_list_url: form.cauth.params.sudo_ca_list_url,
      cauth_trusted_sources: form.cauth.params.trusted_sources,

      // cms
      cms: form.cmsSettings.map(e => formParamsToCms(e.params)),

      // vlans
      extra_vlans: form.vlans.params.extra_vlans,
      hbf_project_id: form.vlans.params.hbf_project_id,
      ip_method: form.vlans.params.ip_method,
      native_vlan: form.vlans.params.native_vlan,
      owned_vlans: form.vlans.params.owned_vlans,
      vlan_scheme: form.vlans.params.vlan_scheme,
      use_fastbone: form.vlans.params.use_fastbone,

      // deploying
      ...clearParams(deployingFields, form.deploying.params),

      // profiling
      ...clearParams(profilingFields, form.profiling.params),

      // automation limits and plots
      maintenance_plot_id: form.plots.params.maintenance_plot_id,
      automation_plot_id: form.plots.params.automation_plot_id,
      automation_limits: {
         ...form.automationLimits.params,
         ...form.plots.params.automation_limits,
      },

      host_limits: {
         ...form.hostLimits.params,
         ...form.plots.params.host_limits,
      },

      // restrictions
      default_host_restrictions: form.restrictions.params,

      // manually_disabled_checks
      manually_disabled_checks: form.disabledChecks.params,

      // notifications
      notifications: {
         recipients: form.notifications.params.recipients,
      },

      // reports
      reports: form.reports.params,

      // automations
      dns_domain: form.automations.params.dns_domain || undefined,
      dns_automation: { enabled: form.automations.params.dns },
      healing_automation: { enabled: form.automations.params.healing },

      // others
      reboot_via_ssh: form.others.params.reboot_via_ssh,
      tier: form.others.params.tier,
   };
   // tslint:enable:object-literal-sort-keys
}
