import { FormFieldType, FormLayout, IFormField, isEmpty, useIgnoreEvent } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { AutomationsFormParams } from '../../../../state/fullProjectForm';
import { FormProps } from '../../models';
import { BooleanSwitcherField } from 'rich_shared/form_fields';

const fields: IFormField<AutomationsFormParams>[] = [
   {
      label: 'Healing automation',
      name: 'healing',
      type: FormFieldType.Custom,
      component: BooleanSwitcherField,
   },
   {
      label: 'DNS domain',
      name: 'dns_domain',
      type: FormFieldType.String,
   },
   {
      isDisabled: p => isEmpty(p.dns_domain),
      label: 'DNS automation',
      name: 'dns',
      type: FormFieldType.Custom,
      component: BooleanSwitcherField,
   },
];

export const AutomationsForm = React.memo(({ value, onChange, validation }: FormProps<AutomationsFormParams>) => (
   <FormLayout fields={fields} value={value} validationResult={validation} onChange={useIgnoreEvent(onChange)} />
));

AutomationsForm.displayName = 'AutomationsForm';
