import { boolean } from '@storybook/addon-knobs';
import { json } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { createProjectOwners } from '../../../../models';
import { ProjectIdContext } from '../../../../shared';
import { BasicFormParams, getFormParams, initialState } from '../../../../state/fullProjectForm';
import { reduxStoryDecorator } from '../../../../stories';
import { useFormParams } from '../../../../stories/reactHooks';
import { IStoryDefaults } from '../../../../stories/typings';

import { BasicForm } from './BasicForm';

const owners = new Set(['khoden']);

const existed = getFormParams<BasicFormParams>({
   _owners: createProjectOwners({ actualOwners: owners }),
   bot_project_id: 100001955, // runtimecloud
   id: 'test',
   name: 'Testing',
   owners,
   tags: new Set(['tag1', 'tag2']),
   roles: {
      'user': ['khoden'],
   },
   yc_iam_folder_id: undefined,
});

export const New = () => {
   const [{ params, validation }, updateParams] = useFormParams(initialState.basic);

   return (
      <>
         <ProjectIdContext.Provider value={'test'}>
            <BasicForm
               isNew={boolean('isNew', true)}
               readonly={boolean('readonly', false)}
               isOwnersSaving={boolean('isOwnersSaving', false)}
               value={params}
               validation={validation}
               onChange={updateParams}
            />
         </ProjectIdContext.Provider>

         <pre>{json(params)}</pre>
      </>
   );
};

export const Readonly = () => {
   const [{ params, validation }, updateParams] = useFormParams(existed);

   return (
      <>
         <ProjectIdContext.Provider value={'test'}>
            <BasicForm
               isNew={boolean('isNew', false)}
               readonly={boolean('readonly', true)}
               isOwnersSaving={boolean('isOwnersSaving', false)}
               value={params}
               validation={validation}
               onChange={updateParams}
            />
         </ProjectIdContext.Provider>

         <pre>{json(params)}</pre>
      </>
   );
};

export const Editable = () => {
   const [{ params, validation }, updateParams] = useFormParams(existed);

   return (
      <>
         <ProjectIdContext.Provider value={'test'}>
            <BasicForm
               isNew={boolean('isNew', false)}
               readonly={boolean('readonly', false)}
               isOwnersSaving={boolean('isOwnersSaving', false)}
               value={params}
               validation={validation}
               onChange={updateParams}
            />
         </ProjectIdContext.Provider>

         <pre>{json(params)}</pre>
      </>
   );
};

export default {
   decorators: [reduxStoryDecorator],
   title: 'project|sub_forms/BasicForm',
} as IStoryDefaults;
