import { FormFieldType, FormLayout, IFormField, useIgnoreEvent } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { config } from 'services';

import { HELP_HINTS, ProjectType } from '../../../../models';
import {
   BotProjectSelectField,
   createTitleField,
   EnumSelectField,
   ProjectIdField,
   ProjectOwnersField,
   ProjectRolesEditorField,
   ProjectTagsInputField,
} from '../../../../rich_shared/form_fields';

import { BasicFormParams } from '../../../../state/fullProjectForm';
import { FormProps } from '../../models';

interface FormContext {
   isNew: boolean;
   isShadow: boolean;
   projectId?: string;
}

const fields: IFormField<BasicFormParams>[] = [
   {
      component: EnumSelectField,
      label: 'Type',
      name: 'type',
      options: [
         { title: 'server', value: ProjectType.SERVER },
         { title: 'vm', value: ProjectType.VM },
         { title: 'mac', value: ProjectType.MAC },
      ],
      isDisabled: (p, context: FormContext) => !context.isNew,
      placeholder: 'Select type',
      type: FormFieldType.Custom,
   },
   {
      component: ProjectIdField,
      hint: HELP_HINTS.projectFields.name,
      label: 'Project name',
      name: 'name',
      placeholder: 'Enter project name',
      required: true,
      type: FormFieldType.Custom,
   },
   {
      component: ProjectIdField,
      hint: HELP_HINTS.projectFields.id,
      isDisabled: (p, context: FormContext) => !context.isNew,

      label: 'Project id/slug',
      name: 'id',
      placeholder: 'Enter project ID',
      required: true,
      type: FormFieldType.Custom,
   },
   {
      component: ProjectTagsInputField,
      label: 'Project tags',
      name: 'tags',
      placeholder: 'Enter project tags',
      isHidden: (_, context) => context.isShadow,
      type: FormFieldType.Custom,
   },
   {
      component: BotProjectSelectField,
      // -1 - BOT проект не найден
      getError: p => (p.bot_project_id === -1 ? "BOT project hasn't synced yet with the ABC-service" : null),
      label: 'BOT Project ID',
      name: 'bot_project_id',
      placeholder: 'Enter ABC service',
      required: true,
      type: FormFieldType.Custom,
   },
];
const fieldsExternal: IFormField<BasicFormParams>[] = [
   // @ts-ignore
   ...fields,
   {
      type: FormFieldType.String,
      label: 'Folder ID',
      name: 'yc_iam_folder_id',
      placeholder: 'Enter a folder ID for YC iam',
      required: true,
   },
];
const fieldsInternal: IFormField<BasicFormParams>[] = [
   ...fields,
   {
      component: ProjectOwnersField,
      label: 'Owners',
      name: '_owners',
      type: FormFieldType.Custom,
   },
   {
      component: createTitleField('Roles'),
      label: '',
      name: 'roles',
      type: FormFieldType.Custom,
      isHidden: (_, context) => context.isNew,
   },
   {
      component: ProjectRolesEditorField,
      label: 'Roles',
      name: 'roles',
      type: FormFieldType.Custom,
      isHidden: (_, context) => context.isNew,
   },
];

interface Props extends FormProps<BasicFormParams>, FormContext {
   isOwnersSaving: boolean;
   readonly: boolean;
}

export const BasicForm: React.FC<Props> = React.memo(
   ({ value, onChange, validation, isNew, projectId, readonly, isOwnersSaving, isShadow }) => (
      <FormLayout
         fields={config.isExternal ? fieldsExternal : isShadow ? fields : fieldsInternal}
         value={value}
         validationResult={validation}
         onChange={useIgnoreEvent(onChange)}
         readonly={readonly}
         context={{ isNew, projectId, isOwnersSaving, isShadow }}
      />
   ),
);

BasicForm.displayName = 'BasicForm';
