import { FormFieldType, FormLayout, IFormField, isEqual, useIgnoreEvent } from '@yandex-infracloud-ui/libs';
import { CAuthFlowType, CAuthKeySources, CAuthTrustedSources } from 'models';
import React, { useCallback } from 'react';
import { EnumSelectField } from 'rich_shared/form_fields';

import { CAuthFormParams } from '../../../../state/fullProjectForm';
import { FormProps } from '../../models';
import { CmsApiUrlField } from '../CmsForm/CmsApiUrlField';
import { MultySelect } from './MultySelect';

interface Props extends FormProps<CAuthFormParams> {
   readonly: boolean;
}

export const cAuthFields: IFormField<CAuthFormParams>[] = [
   {
      component: EnumSelectField,
      label: 'Flow type',
      name: 'flow_type',
      options: [
         { title: 'Classic', value: CAuthFlowType.Classic },
         { title: 'Backend source', value: CAuthFlowType.BackendSource },
      ],
      hint: 'CAuth trusted sources management type',
      type: FormFieldType.Custom,
   },
   {
      component: MultySelect,
      label: 'Trusted sources',
      name: 'trusted_sources',
      options: [
         { title: 'Bot', value: CAuthTrustedSources.Bot },
         { title: 'Cms', value: CAuthTrustedSources.Cms },
         { title: 'Conductor', value: CAuthTrustedSources.Conductor },
         { title: 'Hd', value: CAuthTrustedSources.Hd },
         { title: 'Idm', value: CAuthTrustedSources.Idm },
         { title: 'IdmCms', value: CAuthTrustedSources.IdmCms },
         { title: 'IdmConductor', value: CAuthTrustedSources.IdmConductor },
         { title: 'Walle', value: CAuthTrustedSources.Walle },
         { title: 'Ycloud', value: CAuthTrustedSources.Ycloud },
         { title: 'Yp', value: CAuthTrustedSources.Yp },
      ],
      type: FormFieldType.Custom,
      isHidden: p => {
         return p.flow_type === CAuthFlowType.Classic;
      },
   },
   {
      component: MultySelect,
      label: 'Sources for keys',
      name: 'key_sources',
      options: [
         { title: 'Insecure', value: CAuthKeySources.Insecure },
         { title: 'Secure', value: CAuthKeySources.Secure },
         { title: 'Staff', value: CAuthKeySources.Staff },
      ],
      type: FormFieldType.Custom,
   },
   {
      component: CmsApiUrlField,
      label: 'Insecure CA list URL',
      name: 'insecure_ca_list_url',
      placeholder: 'Enter custom URL for insecure CA list',
      type: FormFieldType.Custom,
   },
   {
      component: CmsApiUrlField,
      label: 'KRL URL',
      name: 'krl_url',
      placeholder: 'Enter custom URL for KRL',
      type: FormFieldType.Custom,
   },
   {
      component: CmsApiUrlField,
      label: 'Secure CA list URL',
      name: 'secure_ca_list_url',
      placeholder: 'Enter custom URL for secure CA list',
      type: FormFieldType.Custom,
   },
   {
      component: CmsApiUrlField,
      label: 'Sudo CA list URL',
      name: 'sudo_ca_list_url',
      placeholder: 'Enter custom URL for sudo CA list',
      type: FormFieldType.Custom,
   },
];

export const CAuthForm: React.FC<Props> = React.memo(({ readonly, value, onChange, validation }) => {
   const onFormUpdate = useCallback(
      (v: CAuthFormParams) => {
         // _type changed
         if (!isEqual(value.flow_type, v.flow_type)) {
            switch (v.flow_type) {
               case CAuthFlowType.Classic: {
                  v.trusted_sources = [];
                  break;
               }
               default:
                  break;
            }
         }

         onChange(v);
      },
      [onChange, value],
   );

   return (
      <FormLayout
         fields={cAuthFields}
         value={value}
         validationResult={validation}
         onChange={useIgnoreEvent(onFormUpdate)}
         readonly={readonly}
      />
   );
});
