import { EMPTY_VALUE, FieldLayout, IFieldProps, isEmpty } from '@yandex-infracloud-ui/libs';
import { YCSelect } from '@yandex-data-ui/common';
import * as React from 'react';
import { useCallback } from 'react';

import classes from './MultySelect.module.css';

export const MultySelect = React.memo(
   ({ value, disabled, config, readonly, help, error, onChange }: IFieldProps<string[]>) => {
      const updateType = useCallback(
         (v: string[]) => {
            onChange(null, v);
         },
         [onChange],
      );

      return (
         <FieldLayout config={config} help={help} error={error}>
            {readonly ? (
               !isEmpty(value) ? (
                  value.join(', ')
               ) : (
                  EMPTY_VALUE
               )
            ) : (
               <YCSelect
                  onUpdate={updateType}
                  className={classes.select}
                  type={'multiple'}
                  value={value}
                  items={config.options}
                  showSearch={false}
                  placeholder={config.placeholder}
                  disabled={disabled}
               />
            )}
         </FieldLayout>
      );
   },
);

MultySelect.displayName = 'MultySelect';
