import { EMPTY_VALUE, FieldLayout, IFieldProps } from '@yandex-infracloud-ui/libs';
import { TextInput } from 'lego-on-react';
import * as React from 'react';
import { useCallback } from 'react';

export const CmsApiUrlField = React.memo(
   ({ value, disabled, config, readonly, help, error, onChange }: IFieldProps<string>) => {
      const handleUrlChange = useCallback((v: string) => onChange(null, v), [onChange]);

      return (
         <FieldLayout config={config} help={help} error={error}>
            {readonly ? (
               value || EMPTY_VALUE
            ) : (
               <TextInput
                  theme={'normal'}
                  size={'s'}
                  type={'text'}
                  name={config.name}
                  placeholder={config.placeholder}
                  text={value}
                  disabled={disabled}
                  onChange={handleUrlChange}
               />
            )}
         </FieldLayout>
      );
   },
);

CmsApiUrlField.displayName = 'CmsApiUrlField';
